<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Video extends Model
{
    use HasFactory;
    protected $fillable = ['uuid','video_url','trading_type_id','status'];
    protected $casts = ['uuid' => 'string',
                      'video_url' => 'string',
                      'trading_type_id' => 'integer'];

    public function tradingType()
    {
        return   $this->belongsTo(TradingType::class);
    }
    protected static function booted()
    {
        static::addGlobalScope('active', function ($builder) {
            $builder->where('status', 1);
        });
    }
}
