<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

class User extends Authenticatable
{
    use HasApiTokens;
    use HasFactory;
    use Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'first_name',
        'email',
        'password',
        'uuid',
        'last_name',
        'address',
        'zip',
        'city',
        'status' ,
        'url_image',
        'code',
        'email_status',
        'type_payment',
        'email_verified_at',
        'date_active',
        'date_renewal',
        'receive_notification',
        'agree',
        'phone'
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
        'first_name' => 'string',
        'email' => 'string',
        'password' => 'string',
        'uuid' => 'string',
        'last_name' => 'string',
        'address' => 'string',
        'zip' => 'string',
        'city' => 'string',
        'status' => 'boolean',
        'url_image' => 'string',
        'code' => 'string',
        'email_status' => 'boolean',
        'type_payment' => 'string',
        'date_active' => 'date',
        'date_renewal' => 'date',
        'receive_notification' => 'boolean',
        'agree' => 'boolean',
        'phone' => 'string'
    ];

    public function favorite()
    {
        return $this->hasOne(Favorite::class);
    }
    protected static function booted()
    {
        static::addGlobalScope('active', function ($builder) {
            $builder->where('status', 1);
        });
    }

    public function emailVerify()
    {
        return $this->hasOne(EmailVerify::class);
    }

    public function renewals()
    {
        return $this->hasMany(Renewal::class);
    }
}
