<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TradingType extends Model
{
    use HasFactory;
    protected $fillable=['uuid','name_type','status','video_name','video_status','chart_name','chart_status'];
    protected $casts=['uuid'=>'string',
                      'name_type'=>'string',
                      'video_name' => 'string',
                      'video_status'=>'boolean',
                      'chart_name'=>'string',
                      'chart_status'=>'boolean',
                      'status'=>'boolean',
                    ];

    public function pairs(){
        return $this->hasMany(Pair::class);
    }

    public function notifications(){
        return $this->hasMany(Notification::class);
    }

    public function videos(){
        return $this->hasMany(Video::class);
    }

    protected static function booted()
    {
        static::addGlobalScope('active', function ($builder) {
            $builder->where('status', 1);
        });
    }


}
