<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ResetPassword extends Model
{
    use HasFactory;

    protected $fillable = ['uuid','user_id','email','token','status'];
    protected $casts = ['uuid' => 'string',
                      'user_id' => 'integer',
                      'email' => 'string',
                      'token' => 'string',
                      'status' =>'boolean'
                    ];

    public function User()
    {
        return $this->belongsTo(User::class);
    }
}
