<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Renewal extends Model
{
    use HasFactory;
    protected $fillable = [
        'user_id','type','admin_id','uuid'
    ];
    protected $casts=['user_id'=>'integer' , 'admin_id' => 'integer' ,'type'=>'string','uuid'=>'string'];

    public function user()  {
        return $this->belongsTo(User::class);

    }
    public function admin(){
        return $this->belongsTo(Admin::class);
    }


}
