<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PairVariable extends Model
{
    use HasFactory;
    protected $fillable=['uuid','title','image_url','text_description','icon_url','pair_id','status','trading_note'];
    protected $casts=['uuid'=>'string',
                    'title'=>'string',
                    'image_url'=>'string',
                    'text_description'=>'string',
                    'icon_url'=>'string',
                    'pair_id'=>'integer',
                    'trading_note'=>'string'];

    public function pair(){
        return $this->belongsTo(Pair::class);

    }
    protected static function booted()
    {
        static::addGlobalScope('active', function ($builder) {
            $builder->where('status', 1);
        });
    }
}
