<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Pair extends Model
{
    use HasFactory;
    protected $fillable=['uuid','trading_type_id','name_pair','icon_url','status'];
    protected $casts=['uuid'=>'string',
                      'trading_type_id'=>'integer',
                      'name_pair'=>'string',
                      'icon_url'=>'string'];

    public function tradingType(){
        return $this->belongsTo(TradingType::class);
    }

    public function pairVariable(){
        return $this->hasMany(PairVariable::class);
    }

    public function notification(){
        return $this->hasOne(Notification::class);
    }
    protected static function booted()
    {
        static::addGlobalScope('active', function ($builder) {
            $builder->where('status', 1);
        });
    }

}
