<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Notification extends Model
{
    use HasFactory;
    protected $fillable=['uuid','text_notification','trading_type_id','pair_id'];
    protected $casts=['uuid'=>'string',
                        'text_notification'=>'string',
                        'trading_type_id'=>'integer',
                        'pair_id'=>'integer'];

    public function pair(){
        return $this->belongsTo(Pair::class);
    }

    public function tradingType(){
        return $this->belongsTo(TradingType::class);
    }


}
