<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EmailVerify extends Model
{
    use HasFactory;
    protected $fillable = ['uuid','user_id','email_token','check_time'];
    protected $casts = ['uuid' => 'string',
                      'user_id' => 'integer',
                      'email_token' => 'string',
                      'check_time' => 'datetime'
                    ];

    public function User()
    {
        return $this->belongsTo(User::class);
    }

}
