<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Company extends Model
{
    use HasFactory;
    protected $fillable = ['name','uuid','code','status'];
    protected $casts = ['name' => 'string',
                      'uuid' => 'string',
                      'code' => 'string',
                      'status' => 'boolean'];
    protected static function booted()
    {
        static::addGlobalScope('active', function ($builder) {
            $builder->where('status', 1);
        });
    }
}
