<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

class Admin extends Authenticatable
{
    use HasApiTokens;
    use HasFactory;
    use Notifiable;
    protected $fillable = [
        'uuid' ,
        'user_name',
        'password',
        'status'
    ];
    protected $casts = ['user_name' => 'string',
                      'password' => 'string',
                    'status' => 'boolean',
                'uuid' =>'string'];


    public function adminRoles()
    {
        return $this->hasMany(AdminRole::class);
    }

    public function renewals()
    {
        return $this->hasMany(Renewal::class);
    }
}
