<?php

namespace App\Http\Traits;

use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;

trait FileUploader
{
    /**
     * For Upload Images.
     * @param mixed $request
     * @param mixed $data
     * @param mixed $name
     * @param mixed|null $inputName
     * @return bool|string
     */
    public function uploadImagePublic($request, $data, $name, $inputName = 'image')
    {
        $requestFile = $request->file($inputName);
        try {
            $dir = 'public/images/'.$name;
            $randomNumber = Str::random(5);
            $fixName = $data->id.'-'.$randomNumber.'-'.'.'.$requestFile->extension();
            if ($requestFile) {
                $url =  Storage::putFileAs($dir, $requestFile, $fixName);

                $request->image = $fixName;
            }

            return $url;
        } catch (\Throwable $th) {
            report($th);

            return $th->getMessage();
        }
    }

    public function uploadImagePrivate($request, $data, $name, $inputName = 'image')
    {
        $requestFile = $request->file($inputName);

        try {
            $dir = 'images/'.$name;
            $randomNumber = Str::random(5);
            $fixName = $data->id.'-'.$randomNumber.'-'.'.'.$requestFile->extension();
            if ($requestFile) {
                $url =  Storage::putFileAs($dir, $requestFile, $fixName);
                $request->image = $fixName;
            }
            return $url;
        } catch (\Throwable $th) {
            report($th);
            return $th->getMessage();
        }
    }
}
