<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class UserResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'uuid' => $this->uuid,
            'email' => $this->email,
            'first_name' => $this->first_name,
            'last_name' => $this->last_name,
            'address' => $this->address,
            'zip' => $this->zip,
            'city' => $this->city,
            'url_image' => ($this->url_image) ? $this->url_image:null,
            'date_active'=>($this->date_active) ?$this->date_active :null,
            'date_renewal'=>($this->date_renewal) ?$this->date_renewal :null,
            'status'=>$this->status,
            'receive_notification'=> $this->receive_notification,
            'agree'=> $this->agree,
            'phone' => $this->phone,
            'email_status' => ($this->email_status)?? false,


        ];
    }
}
