<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class PairWithVariablesResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
{
    $uuidToCheck = $this->uuid;
    $user = auth('sanctum')->user();

    if ($user->favorite) {
        $userFavorite = json_decode($user->favorite->pair_favorite, true) ?? [];
        $uuidExists = in_array($uuidToCheck, array_column($userFavorite, 'pair_uuid'));
    } else {
        $uuidExists = false;
    }

    return [
        'uuid' => $this->uuid,
        'name_pair' => $this->name_pair,
        'icon_url' => $this->icon_url ?? null,
        'pair_variables' => PairVariableResource::collection($this->pairVariable->where('status', 1)),
        'status_favorite' => ($uuidExists) ? 'true' : 'false',
        'created_at' => $this->created_at->diffForHumans(),
        'updated_at' => $this->updated_at->diffForHumans(),
    ];
}


}
