<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class PairVariableResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'uuid' => $this->uuid,
            'title' => $this->title,
            'image_url' => ($this->image_url) ? $this->image_url:null,
            'text_description' => $this->text_description,
            'icon_url' => ($this->icon_url) ? $this->icon_url:null,
            'status'=>$this->status,
            'trading_note' => ($this->trading_note) ?$this->trading_note : null,
            'created_at' => $this->created_at->diffForHumans(),
            'updated_at' => $this->updated_at->diffForHumans(),
        ];
    }
}
