<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class PairResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'uuid' => $this->uuid,
            'name_pair' => $this->name_pair,
            'icon_url' =>($this->icon_url) ? $this->icon_url:null,
            'uuid_trading_type'=> $this->tradingType->uuid,
            'name_trading_type'=> $this->tradingType->name_type,
            'status'=>$this->status,
            'text_notification' =>$this->notification->text_notification ?? '',
            'created_at' => $this->created_at->diffForHumans(),
            'updated_at' => $this->updated_at->diffForHumans(),

        ];
    }
}
