<?php

namespace App\Http\Middleware;

use App\Http\Traits\GeneralTrait;
use Closure;
use Illuminate\Http\Request;

class AdminRoleMiddleware
{
    use GeneralTrait;
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next, ...$allowedRoles)
    {
        if ($request->is('api/*')) {
            if (auth('admin')->check()) {
                $admin = auth('admin')->user();

                // Retrieve the admin's roles
                $adminRoles = $admin->adminRoles; // Assuming you have defined a 'roles' relationship in your Admin model

                // Check if the admin has at least one of the allowed roles
                if ($adminRoles->whereIn('role.name_role', $allowedRoles)->count() > 0 && $admin->status == 1) {
                    return $next($request);
                }
            }
        }

        return $this->unAuthorizeResponse('Unauthorize to admin');
    }
}
