<?php

namespace App\Http\Controllers\TimeZones;

use App\Http\Controllers\Controller;
use App\Http\Resources\TimeZoneResource;
use App\Http\Traits\GeneralTrait;
use App\Models\TimeZone;
use Illuminate\Http\Request;

class TimeZoneController extends Controller
{
    use GeneralTrait;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        try {
            $timeZone = TimeZone::all();
            $data['timeZone'] = TimeZoneResource::collection($timeZone);

            return $this->apiResponse($data, true, null, 200);
        } catch (\Exception $ex) {
            return $this->apiResponse(null, false, $ex->getMessage(), 500);
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\TimeZone  $timeZone
     * @return \Illuminate\Http\Response
     */
    public function show(TimeZone $timeZone)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\TimeZone  $timeZone
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, TimeZone $timeZone)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\TimeZone  $timeZone
     * @return \Illuminate\Http\Response
     */
    public function destroy(TimeZone $timeZone)
    {
        //
    }
}
