<?php

namespace App\Http\Controllers\Notifications;

use App\Http\Controllers\Controller;
use App\Http\Resources\NotificationResource;
use App\Http\Traits\GeneralTrait;
use App\Models\Notification;
use App\Models\TradingType;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class NotificationController extends Controller
{
 use GeneralTrait;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Notification  $notification
     * @return \Illuminate\Http\Response
     */
    public function show(Notification $notification)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Notification  $notification
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Notification $notification)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Notification  $notification
     * @return \Illuminate\Http\Response
     */
    public function destroy(Notification $notification)
    {
        //
    }

    public function getNotificationsByTradingType($uuidTradingType)
{
    $validator = Validator::make(['uuidTradingType' => $uuidTradingType], [
        'uuidTradingType' => 'required|string|exists:trading_types,uuid',

    ]);

    if ($validator->fails()) {
        return $this->requiredField($validator->errors()->first());
    }
    try {
        $tradingType = TradingType::where('uuid', $uuidTradingType)->first();

        if (!$tradingType) {
            return $this->notFoundResponse('Trading type not found');
        }

        $notifications = $tradingType->notifications;

        $data['notifications'] = NotificationResource::collection($notifications);


        return $this->apiResponse($data, true, null, 200);
    } catch (\Exception $ex) {
        return $this->apiResponse(null, false, $ex->getMessage(), 500);
    }
}
}
