<?php

namespace App\Http\Controllers\Favorites;

use App\Http\Controllers\Controller;
use App\Http\Resources\PairWithVariablesResource;
use App\Http\Traits\GeneralTrait;
use App\Models\Favorite;
use App\Models\Pair;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator ;
use Illuminate\Support\Str ;

class FavoriteController extends Controller
{
    use GeneralTrait;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'pair_uuid' => ['required', 'string', 'exists:pairs,uuid'],
        ]);

        if ($validator->fails()) {
            return $this->requiredField($validator->errors()->first());
        }

        $user = auth('sanctum')->user();
        $pairUUID = $request->input('pair_uuid');

        try {
            $favorite = Favorite::where('user_id', $user->id)->first();
            $currentPairs = [];

            if ($favorite) {
                $currentPairs = json_decode($favorite->pair_favorite, true) ?? [];
            }

            // Check if the pair_uuid already exists in the current pairs
            $existingPair = array_filter($currentPairs, function ($pair) use ($pairUUID) {
                return $pair['pair_uuid'] === $pairUUID;
            });

            if (empty($existingPair)) {
                // If the pair_uuid doesn't exist, add it to the current pairs
                $currentPairs[] = ['pair_uuid' => $pairUUID];
            }

            if (!$favorite) {
                $uuid = Str::uuid();

                $newFavorite = new Favorite();
                $newFavorite->uuid = $uuid;
                $newFavorite->user_id = $user->id;
                $favorite = $newFavorite;
            }

            $favorite->pair_favorite = json_encode($currentPairs);
            $favorite->save();

            $data['message'] = 'Pair added to Favorite successfully';
            return $this->apiResponse($data, true, null, 200);
        } catch (\Exception $ex) {
            return $this->apiResponse(null, false, $ex->getMessage(), 500);
        }
    }

    


    public function removeFavorite(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'pair_uuid' => ['required','string','exists:pairs,uuid'],
        ]);

        if ($validator->fails()) {
            return $this->requiredField($validator->errors()->first());
        }

        $user = auth('sanctum')->user();

        try {
            $favorite = Favorite::where('user_id', $user->id)->first();

            if (!$favorite) {
                return $this->requiredField('You have no favorite items to remove.');
            }

            $pairUUIDToRemove = $request->input('pair_uuid');
            $currentPairs = json_decode($favorite->pair_favorite, true);

            // Find the index of the item to be removed
            $indexToRemove = null;
            foreach ($currentPairs as $index => $pair) {
                if ($pair['pair_uuid'] === $pairUUIDToRemove) {
                    $indexToRemove = $index;
                    break;
                }
            }

            // Remove the item if found
            if ($indexToRemove !== null) {
                unset($currentPairs[$indexToRemove]);
                $favorite->pair_favorite = json_encode(array_values($currentPairs)); // Reorder keys
                $favorite->save();
            } else {
                return $this->requiredField('The pair is not found in the favorite items array.');
            }

            $data['message'] = 'Pair removed from Favorite successfully';
            return $this->apiResponse($data, true, null, 200);
        } catch (\Exception $ex) {
            return $this->apiResponse(null, false, $ex->getMessage(), 500);
        }
    }


}
