<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use App\Http\Resources\NotificationResource;
use App\Http\Resources\PairWithVariablesResource;
use App\Http\Resources\UserResource;
use App\Http\Resources\VideoResource;
use App\Http\Traits\GeneralTrait;
use App\Models\TradingType;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class DashboardController extends Controller
{
    use GeneralTrait;
    public function dashboard(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'nameTradingType' => 'required|string|exists:trading_types,name_type',

        ]);

        if ($validator->fails()) {
            return $this->requiredField($validator->errors()->first());
        }
        try {

            $tradingType = TradingType::where('name_type', $request->nameTradingType)->firstOrFail();
            $pairs = $tradingType->pairs()->where('status', 1)->get();
            $videos = $tradingType->videos;
            $notifications = $tradingType->notifications;

            $user = auth('sanctum')->user();
            $data['pairs'] = PairWithVariablesResource::collection($pairs);
            $data['videos'] = VideoResource::collection($videos);
            $data['notifications'] = NotificationResource::collection($notifications);

            return $this->apiResponse($data, true, null, 200);
        } catch (\Exception $ex) {

            return $this->apiResponse(null, false, $ex->getMessage(), 500);
        }

    }
}
