<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Traits\GeneralTrait;
use App\Models\EmailVerify;
use App\Models\User;
use Illuminate\Http\Request;

use Carbon\Carbon;


class VerificationController extends Controller
{
    use GeneralTrait;
    public function verifyEmail(Request $request)
    {
        try {
            $emailVerify = EmailVerify::where('email_token', $request->token)->first();

            if (!$emailVerify) {
                return $this->requiredField('Invalid verification token');
            }

            // Check if the token has expired (more than 60 minutes)
            if ($emailVerify->created_at->diffInMinutes(now()) > 60) {
                // Token has expired, you can handle this as needed (e.g., show an error message)
                return $this->requiredField('Email verification token has expired.');
            }




            // Now you can update the corresponding user's email verification status
            $user = User::withoutGlobalScope('active')->find($emailVerify->user_id);

            if (!$user) {
                return $this->requiredField('User not found for this token');
            }

            if ($user->email_status) {
                return $this->requiredField('Email is already verified');
            }

            $emailVerify->update(['check_time' => now()]);

            $user->update([
                'email_verified_at' => Carbon::now(),
                'email_status' => 1
            ]);

            // // Optionally, you can also clear the email_token field in EmailVerify
            // $emailVerify->update(['email_token' => null]);
            $data['message']='Email verification successful.';

            return $this->apiResponse($data, true, null, 200);
        } catch (\Exception $ex) {
            return $this->apiResponse(null, false, $ex->getMessage(), 500);
        }
    }
}
