<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Resources\UserResource;
use App\Http\Traits\GeneralTrait;
use App\Models\ResetPassword;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;

class ForgotPasswordController extends Controller
{
use GeneralTrait;
    public function forgot_password(Request $request)
    {
        try {
            // $request->validate(['email' => 'required|email']);

            $user = User::withoutGlobalScope('active')->where('email', $request->email)->firstOrFail();



            $token = Str::random(60);
            $resetPassword = ResetPassword::create([
                'uuid' => Str::uuid(),
                'user_id' => $user->id,
                'email' => $request->email,
                'token' => $token,
            ]);
            $verificationUrl = url("https://stage.diversifinance.com/reset_password?reset_token={$resetPassword->token}");


            $email = $request->email;
            $templateName = "emails.forgot-password";
            $data = [
                'user' => $user,
                'verificationUrl' => $verificationUrl,
            ];
            $this->send_email($templateName, $email, 'Password Reset', $data);

            return $this->apiResponse(['message'=>'The email was sent successfully'], true, null, 200);
        } catch (\Exception $ex) {
            return $this->apiResponse(null, false, $ex->getMessage(), 500);
        }
    }


    public function checkToken(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'token' => 'required|string',

        ]);

        // Check if validation fails and return errors if any
        if ($validator->fails()) {
            return $this->requiredField($validator->errors()->first());
        }
        try {
            $token = $request->input('token');

            $resetPassword = ResetPassword::where('token', $token)->where('status',0)->first();

            if ($resetPassword) {
                $email=$resetPassword->user->email;
                return $this->apiResponse(['message' => 'Valid token','email'=>$email], true, null, 200);
            } else {

                return $this->apiResponse(['message' => 'Invalid token'], false, 'Invalid token', 400);
            }
        } catch (\Exception $ex) {
            return $this->apiResponse(null, false, $ex->getMessage(), 500);
        }
    }


    public function resetPassword(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'new_password' => 'required|string|min:8|confirmed',
            'token' => 'required|string',
            'email' => 'required|email',
        ]);

        if ($validator->fails()) {
            return $this->requiredField($validator->errors()->first());
        }

        try {
            $resetPassword = ResetPassword::where('email', $request->input('email'))
                ->where('token', $request->input('token'))
                ->where('created_at', '>=', now()->subHour()) // Check if token is less than an hour old
                ->first();
                if(!$resetPassword){
                    return $this->apiResponse([], false, 'Invalid token', 400);
                }

            $user = User::withoutGlobalScope('active')
                ->where('email', $request->input('email'))
                ->firstOrFail();



            $user->update([
                'password' => Hash::make($request->new_password),
            ]);

            // Update the status to 1
            $resetPassword->update(['status' => 1]);

            $data['user'] = new UserResource($user);

            return $this->apiResponse($data, true, null, 200);
        } catch (\Exception $ex) {
            return $this->apiResponse(null, false, $ex->getMessage(), 500);
        }
    }

}
