<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Resources\TradingTypeResource;
use App\Http\Resources\UserResource;
use App\Http\Traits\GeneralTrait;
use App\Mail\EmailVerificationMail;
use App\Models\EmailVerify;
use App\Models\ResetPassword;
use App\Models\TradingType;
use App\Models\User;
use App\Notifications\WelcomeNotification;
use Illuminate\Http\Request;
use Illuminate\Mail\Message;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Password;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use Illuminate\Auth\Events\PasswordReset;
use Illuminate\Http\Response;
use Swift_TransportException;
use Exception;
use Illuminate\Support\Facades\Mail;
use Illuminate\Validation\ValidationException;

class AuthController extends Controller
{
    use GeneralTrait;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function login(Request $request)
    {
        // Validate the incoming request data
        $validator = Validator::make($request->all(), [
            'email' => 'required|email',
            'password' => 'required|',
        ]);

        // Check if validation fails and return errors if any
        if ($validator->fails()) {
            return $this->requiredField($validator->errors()->first());
        }

        try {
            // Attempt to find the user by phone number
            $user = User::withoutGlobalScope('active')->where('email', $request->input('email'))->first();

            // Verify the phone
            if (!$user) {
                return $this->apiResponse(null, false, 'Invalid email Or Password .', 401);
            }

            // Verify the password
            if (!Hash::check($request->input('password'), $user->password)) {
                return $this->apiResponse(null, false, 'Invalid email Or Password .', 401);
            }

            if ($user->status_email === false) {
                return $this->apiResponse(null, false, 'Please contact the administrator to activate your account.', 401);
            }
            if ($user->status === false) {
                return $this->apiResponse(null, false, 'admin not accept.', 401);
            }

            $trading_types = TradingType::all();

            // Generate a token for the user
            $data['user'] = new UserResource($user);
            $data['token'] = $user->createToken('MyApp')->plainTextToken;
            $data['TradingTypes'] = TradingTypeResource::collection($trading_types);

            return $this->apiResponse($data, true, null, 200);
        } catch (\Exception $ex) {
            return $this->apiResponse(null, false, $ex->getMessage(), 500);
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function register(Request $request)
    {
        // Validate the incoming request data
        $validator = Validator::make($request->all(), [
        'email' => 'required|email|unique:users,email',
        'password' => 'required|string|min:8|confirmed',
        'first_name' => 'required|string',
        'last_name' => 'required|string',
        'phone'  => 'required|string',
        'code' => 'string',
        'receive_notification' => 'required|boolean',
        'agree' => 'required|accepted',


        ]);

        // Check if validation fails and return errors if any
        if ($validator->fails()) {
            return $this->requiredField($validator->errors()->first());
        }

        try {

            // Create a new user using the request data
            $user = User::create([
                'uuid' => Str::uuid(),
                'email' => $request->input('email'),
                'password' => Hash::make($request->input('password')),
                'code' => $request->input('code'),
                'status'  => 0,
                'type_payment' => 'Cash',
                'first_name' =>$request->first_name,
                'last_name' =>$request->last_name,
                'phone'=>$request->phone,
                'receive_notification'=>$request->receive_notification,
                'agree'=>1
            ]);
            $emailVerify = EmailVerify::create([
                'uuid' => Str::uuid(),
                'user_id' => $user->id,
                'email_token' => Str::random(60),

            ]);


    $verificationUrl = url("https://stage.diversifinance.com/login?activation_token={$emailVerify->email_token}");

        $templateName = "emails.verify-email";
        $email1 = $request->input('email');
        $subj = "Activation Link";
        $data = [
            'user' => $user, // تمرير المتغير $user
            'verificationUrl' => $verificationUrl,
        ];

        $result = $this->send_email($templateName, $email1, $subj, $data);

        if ($result === true) {
            $data['user'] = new UserResource($user);
            $data['message'] = 'Registration successful. Please check your email to verify your account.';
            return $this->apiResponse($data, true, null, 200);
        } else {

            return $this->apiResponse(null, false, 'Failed to send activation email', 500);
        }


            $data['user'] = new UserResource($user);
           $data['message']= 'Registration successful. Please check your email to verify your account.';
            return $this->apiResponse($data, true, null, 200);
        } catch (\Exception $ex) {
            return $this->apiResponse(null, false, $ex->getMessage(), 500);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\User  $user
     * @return \Illuminate\Http\Response
     */
    public function show(User $user)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\User  $user
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, User $user)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\User  $user
     * @return \Illuminate\Http\Response
     */
    public function destroy(User $user)
    {
        //
    }




}
