<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Traits\GeneralTrait;
use App\Models\Admin;
use App\Models\AdminRole;
use App\Models\Role;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;

class AuthAdminController extends Controller
{
    use GeneralTrait;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\User  $user
     * @return \Illuminate\Http\Response
     */
    public function show(User $user)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\User  $user
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, User $user)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\User  $user
     * @return \Illuminate\Http\Response
     */
    public function destroy(User $user)
    {
        //
    }

    public function login(Request $request)
    {
        // Validate the incoming request data
        $validator = Validator::make($request->all(), [
            'user_name' => 'required|string',
            'password' => 'required',
        ]);

        // Check if validation fails and return errors if any
        if ($validator->fails()) {
            return $this->requiredField($validator->errors()->first());
        }

        try {
            // Attempt to find the user by phone number
            $admin = Admin::where('user_name', $request->input('user_name'))->first();

            // Verify the phone
            if (!$admin) {
                return $this->apiResponse(null, false, 'Invalid User Name Or password .', 401);
            }

            if (!Hash::check($request->input('password'), $admin->password)) {
                return $this->apiResponse(null, false, 'Invalid User Name Or password  .', 401);
            }


            // Generate a token for the user
            $data['name '] = $admin->user_name;
            $data['role'] =  $admin->adminRoles->pluck('role.name_role')->toArray();
            $data['token'] = $admin->createToken('MyApp')->plainTextToken;

            return $this->apiResponse($data, true, null, 200);
        } catch (\Exception $ex) {
            return $this->apiResponse(null, false, $ex->getMessage(), 500);
        }
    }


    public function addAdmin(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'user_name' => 'required|string',
            'password' => 'required',
            'role.*' => 'required|string|in:web,app',

        ]);

        // Check if validation fails and return errors if any
        if ($validator->fails()) {
            return $this->requiredField($validator->errors()->first());
        }
        try {
            // Create the admin user
            $admin = Admin::create([
                'uuid' => Str::uuid(),
              'user_name' => $request->input('user_name'),
              'password' => Hash::make($request->input('password')),
                                 ]);

            // Assign roles to the admin user
            $roleNames = $request->input('role');
            foreach ($roleNames as $roleName) {
                $role = Role::where('name_role', $roleName)->first();
                if ($role) {
                    AdminRole::create([
                        'admin_id' => $admin->id,
                        'role_id' => $role->id,
                    ]);
                }
            }
            $data['name '] = $admin->user_name;
            $data['role'] =  $admin->adminRoles->pluck('role.name_role')->toArray();

            return $this->apiResponse($data, true, null, 200);
        } catch (\Exception $ex) {
            return $this->apiResponse(null, false, $ex->getMessage(), 500);
        }
    }


    public function updateAdmin(Request $request)
{
    $validator = Validator::make($request->all(), [
        'uuid_admin' => 'required|string',
        'user_name' => 'required|string',
        'password' => 'required',
        'role.*' => 'required|string|in:web,app',
    ]);

    // Check if validation fails and return errors if any
    if ($validator->fails()) {
        return $this->requiredField($validator->errors()->first());
    }

    try {
        // Retrieve the admin based on the provided uuid_admin
        $admin = Admin::where('uuid', $request->input('uuid_admin'))->first();

        if (!$admin) {
            return $this->apiResponse(null, false, 'Admin not found', 404);
        }
        $hasRoleSystem = $admin->adminRoles->contains(function ($role) {
            return $role->role->name_role === 'system';
        });

        if ($hasRoleSystem) {
            return $this->apiResponse(null, false, 'Admin does  have the "system" role', 403);
        }

        // Remove the existing roles associated with the admin
        $admin->adminRoles()->delete();

        // Create the admin user
        $admin->update([
            'user_name' => $request->input('user_name'),
            'password' => Hash::make($request->input('password')),
        ]);

        // Assign roles to the admin user
        $roleNames = $request->input('role');
        foreach ($roleNames as $roleName) {
            $role = Role::where('name_role', $roleName)->first();
            if ($role) {
                AdminRole::create([
                    'admin_id' => $admin->id,
                    'role_id' => $role->id,
                ]);
            }
        }

        $data['name'] = $admin->user_name;
        $data['role'] = $admin->adminRoles->pluck('role.name_role')->toArray();

        return $this->apiResponse($data, true, null, 200);
    } catch (\Exception $ex) {
        return $this->apiResponse(null, false, $ex->getMessage(), 500);
    }
}

public function getAllAdmins()
{
    try {
        // Retrieve all admin users without the "system" role
        $admins = Admin::whereHas('adminRoles.role', function ($query) {
            $query->where('name_role', '!=', 'system');
        })->get();

        // Prepare an array to store admin data
        $adminData = [];

        foreach ($admins as $admin) {
            // Retrieve the roles associated with each admin
            $roles = $admin->adminRoles->pluck('role.name_role')->toArray();

            $adminData[] = [
                'uuid_admin' => $admin->uuid,
                'roles' => $roles,
            ];
        }

        return $this->apiResponse(['admins' => $adminData], true, null, 200);
    } catch (\Exception $ex) {
        return $this->apiResponse(null, false, $ex->getMessage(), 500);
    }
}


}
